
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>KydZoo Website- Sign In Page</title>
    <meta name="description" content="Welcome to our website. We offer a variety of useful and interesting content across different topics. Enjoy a rich and informative browsing experience.">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <!-- Swiper Slider CSS -->
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <!-- Custom Styles -->
    <link rel="stylesheet" href="{{asset("website/css/style.css")}}">
    @if(app()->getLocale() == 'ar')
        <link rel="stylesheet" href="{{asset("website/css/style.ar.css")}}">
    @endif
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css">
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Slick Slider JS -->
    <script src="https://cdn.jsdelivr.net/npm/slick-carousel/slick/slick.min.js"></script>
    <!-- Custom Script -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css" integrity="sha512-G3YH6HHwST4lDqlk2JS1UGQYqba50r/5Jd+xrm1jLBVPhPyPnItjR4EaaH1wogRRBNMz69dJe5N08aN5NOYciA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

</head>

<body>



@include('sweetalert::alert')
<div class="container-fluid full-height-section">
    <div class="row no-gutters h-100">
        <!-- Left Part with Image -->
        <div class="col-md-6 d-none d-md-block h-100">
            <div class="signup-img h-100" style="background-image: url('{{ asset("website/assets/images/forget-reset.webp") }}');">
                <!-- Image will be loaded here -->
            </div>
        </div>

        <!-- Right Part with Reset Password Form -->
        <div class="col-md-6 h-100 d-flex align-items-center">
            <div class="forget-reset-pass">
                <h2>Reset Password</h2>
                <p>Please enter your new password.</p>

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('password.update') }}" method="POST" >
                    @csrf
                    <input type="hidden" name="token" value="{{ $token }}">
                    <input type="hidden" name="email" value="{{ $email }}">

                    <div class="form-group custom-input-signup position-relative">
                        <input type="password" class="form-control @error('password') is-invalid @enderror" name="password" id="password" placeholder="New Password" required>
                        <i class="fas fa-eye password-toggle" onclick="togglePassword('password')"></i>
                        @error('password')
                        <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="form-group custom-input-signup position-relative">
                        <input type="password" class="form-control @error('password_confirmation') is-invalid @enderror" name="password_confirmation" id="confirm-password" placeholder="Confirm Password" required>
                        <i class="fas fa-eye password-toggle" onclick="togglePassword('confirm-password')"></i>
                        @error('password_confirmation')
                        <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>

                    <button type="submit" class="btn resetpass-button btn-block">Reset Password</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Popup HTML -->
<div id="popup" class="popup-container d-none">
    <div class="popup-content">
        <div class="popup-left">
            <img src="{{ asset("website/assets/images/truepopup.svg") }}" alt="Icon" class="popup-icon">
            <div class="popup-text">
                <h3>Thank You!</h3>
                <p>Your password was successfully reset.</p>
            </div>
        </div>
        <button class="close-button-popup" onclick="hidePopup()">Close</button>
    </div>
</div>




<script>
    function togglePassword(id) {
        const passwordField = document.getElementById(id);
        const type = passwordField.type === 'password' ? 'text' : 'password';
        passwordField.type = type;
    }

    function showPopup(event) {
        event.preventDefault(); // Prevent the default form submission
        document.getElementById('popup').classList.remove('d-none');
    }

    function hidePopup() {
        document.getElementById('popup').classList.add('d-none');
    }
</script>


<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://code.jquery.com/jquery-migrate-3.0.0.min.js"></script>

<!-- AOS CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css" integrity="sha512-G3YH6HHwST4lDqlk2JS1UGQYqba50r/5Jd+xrm1jLBVPhPyPnItjR4EaaH1wogRRBNMz69dJe5N08aN5NOYciA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<!-- Bootstrap -->
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script src="{{asset("website/assets/js/popper.min.js")}}"></script>
<script src="{{asset("website/assets/js/bootstrap.min.js")}}"></script>

<!-- Slick Slider -->
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css"/>
<script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>

<!-- mmenu -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jQuery.mmenu/8.5.13/mmenu.min.js"></script>

<!-- Nice Select & Wow & Parallax -->
<script src="{{asset("website/assets/js/jquery.nice-select.min.js")}}"></script>
<script src="{{asset("website/assets/js/wow.js")}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/parallax/3.1.0/parallax.min.js"></script>

<!-- GSAP (for loading page) -->
<script src="https://unpkg.com/gsap@3/dist/gsap.min.js"></script>

<!-- FancyBox (for image or video popup) -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>

<!-- AOS JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js" integrity="sha512-Xk/5uHBm6F59Ecf7DzN93ewP2eRTtM0NFdQUz3xv2d+1V/kd+ufPQyM4o5XzY0/ymuwVp6LMTPhvquKeXilrMg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

<!-- Waypoints & CounterUp (for animation) -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/waypoints/2.0.5/waypoints.min.js"></script>
<script src="{{asset("website/assets/js/jquery.counterup.min.js")}}"></script>

<!-- Swiper Slider -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/4.2.0/js/swiper.js"></script>

<!-- Main Script -->
<script src="{{asset('website/js/main.js')}}"></script>

<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<!-- Initialize AOS -->
<script>
    AOS.init();
</script>


</body>
</html>




