<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Order extends BaseModel
{
    use HasFactory;
    use HasUuids;

    protected $table = 'orders';
    protected $fillable = [
        'user_id',
        'session_id',
        'status',
        'amount',
        'transaction_json',
        'productable_id',
        'productable_type',
    ];

    // Cast attributes to native types
    protected $casts = [
        'transaction_json' => 'array',
        'user_id' => 'string',
        'session_id' => 'string',
        'amount' => 'float',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    // Polymorphic relation to products (Event, Book, Course)
    public function productable()
    {
        return $this->morphTo();
    }


}
