<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Announcement extends Model  implements HasMedia
{
    use HasFactory;
    use HasUuids;
    use InteractsWithMedia;

    protected $table = 'announcements';
    protected $fillable = [
        'title_ar',
        'title_en',
        'description_ar',
        'description_en',
        'announcement_url',
        'status',
        'type',
    ];

    protected $casts = [
        'status' => 'boolean',
        'type' => 'integer',
    ];
}
