<?php

use App\Models\Brand\Brand;
use App\Models\Category\Category;
use App\Models\Color\Color;
use App\Models\Product\Product;

/**
 * get supported languages
 * @return array
 */
function supportedLanguages(): array
{
    return ['en', 'ar'];
}

/**
 * @param $model
 * @param string $column
 * @param string|null $locale
 * @return string|null
 */
function getColumn($model, string $column)
{
    if (!$model) {
        return '';
    }

    return app()->isLocale('ar') ? $model[$column . '_ar'] : $model[$column . '_en'];
}

function slugArabic($title, $separator = '-', $dictionary = ['@' => 'at']): string
{

    $flip = $separator === '-' ? '_' : '-';

    $title = preg_replace('![' . preg_quote($flip) . ']+!u', $separator, $title);

    // Replace dictionary words with their values
    foreach ($dictionary as $key => $value) {
        $dictionary[$key] = $separator . $value . $separator;
    }
    $title = str_replace(array_keys($dictionary), array_values($dictionary), $title);

    // Allow Arabic characters, Latin letters, numbers, and separator, removing others
    $title = preg_replace('![^' . preg_quote($separator) . '\p{Arabic}\pL\pN\s]+!u', '', \Illuminate\Support\Str::lower($title));

    // Replace any remaining whitespace or separator-like characters with a single separator
    $title = preg_replace('![' . preg_quote($separator) . '\s]+!u', $separator, $title);

    return trim($title, $separator);
}
