<?php

namespace App\Enums\Page;

enum Page: string
{
    case PRIVACY_POLICY = "privacy-policy";

    case TERMS_OF_USE = "terms-of-use";


    case COURSES_COVER_DESCRIPTION = 'Courses Cover Description';
    case BLOGS_COVER_DESCRIPTION = 'Blogs Cover Description';
    case BOOKS_COVER_DESCRIPTION = 'Books Cover Description';
    case EVENTS_COVER_DESCRIPTION = 'Events Cover Description';
    case ABOUT_US_COVER_DESCRIPTION = 'About US Cover Description';



    public static function getPages(): array
    {
        return [
            self::PRIVACY_POLICY->value => 'privacy policy',
            self::TERMS_OF_USE->value => 'terms of use',
            self::COURSES_COVER_DESCRIPTION->value => 'Courses Cover Description',
            self::BLOGS_COVER_DESCRIPTION->value => 'Blogs Cover Description',
            self::BOOKS_COVER_DESCRIPTION->value => 'Books Cover Description',
            self::EVENTS_COVER_DESCRIPTION->value => 'Events Cover Description',
            self::ABOUT_US_COVER_DESCRIPTION->value => 'About US Cover Description',

        ];
    }

    public static function getPageType($type): string
    {
        return match ($type) {
            self::PRIVACY_POLICY->value => 'privacy policy',
            self::TERMS_OF_USE->value => 'terms of use',
            self::COURSES_COVER_DESCRIPTION->value => 'Courses Cover Description',
            self::BLOGS_COVER_DESCRIPTION->value => 'Blogs Cover Description',
            self::BOOKS_COVER_DESCRIPTION->value => 'Books Cover Description',
            self::EVENTS_COVER_DESCRIPTION->value => 'Events Cover Description',
            self::ABOUT_US_COVER_DESCRIPTION->value => 'About US Cover Description',
            null => ' ',
        };
    }

}
